IF EXISTS(SELECT * FROM sys.objects 	WHERE  object_id = OBJECT_ID(N'[dbo].[P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO]') AND type IN(N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO];
GO
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221018
'Job.................:  
'Nome................: P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 17/06/2022
'Dt Ult Alteraco....: 18/10/2022
'Criado por..........: Marcos Barros
'Alterado por........: Marcos Barros
'=======================================================================================
*/
--EXEC P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO 927, 0

CREATE PROCEDURE [P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO] ( @CD_FILIAL INT, @CD_PROD  INT = 0) -- QUANDO CD_PROD = 0 SERA REPROCESSADO TODO OS ITENS ATIVOS PARA FILIAL INFORMADA.
AS
BEGIN

IF OBJECT_ID('INTEGRA_BENNER_LOG_REPROCESSAMENTO') IS NULL
BEGIN
	CREATE TABLE INTEGRA_BENNER_LOG_REPROCESSAMENTO (
		CD_FILIAL				INT,
		TOTAL_REGISTROS			INT,
		TIPO_REPROCESSAMENTO	VARCHAR(100),
		DT_HR_ENVIO				DATETIME,
		APLICATIVO				VARCHAR(100),
		HOST					VARCHAR(100)
	)
END;

	
IF EXISTS (SELECT 1 FROM PRC_FILIAL WHERE STS_FILIAL = 0 AND CD_FILIAL  =  @CD_FILIAL)
BEGIN
	IF @CD_PROD = 0
	BEGIN
		INSERT INTO INTEGRA_BENNER_LOG_REPROCESSAMENTO(CD_FILIAL, TOTAL_REGISTROS, TIPO_REPROCESSAMENTO, DT_HR_ENVIO, APLICATIVO, HOST)
			SELECT
				  @CD_FILIAL 	AS CD_FILIAL,
				   SUM(1)	AS TOTAL_REGISTROS,
				   'REPROCESSAMENTO GERAL DE TODOS OS REGISTROS ATIVOS' AS TIPO_REPROCESSAMENTO,
				   CURRENT_TIMESTAMP	AS  DT_HR_ENVIO,
				   APP_NAME()			AS APLICATIVO,
				   HOST_NAME()			AS HOST
			FROM 
				EST_PROD A
			WHERE
				A.STS_PROD = 0
		

		INSERT INTO INTEGRA_BENNER_EVENTOS (TABELA, CD_EMP , CD_FILIAL, CD_REGISTRO, TP_EVENTO, HR_EVENTO, ST_EVENTO , DT_ULT_ALT, CD_USU, DT_DOCUMENTO, APP_NAME, HOST_NAME, TOPICO )
			SELECT
				   'EST_PROD'												AS TABELA
				   ,1														AS CD_EMP
				   ,@CD_FILIAL						      					AS CD_FILIAL
				   ,A.CD_PROD 						        				AS CD_REGISTRO
				   ,1														AS TP_EVENTO
				   ,GETDATE()												AS HR_EVENTO
				   ,0														AS ST_EVENTO
				   ,A.DT_ULT_ATU 			    	        				AS DT_ULT_ALT
				   ,A.CD_USU 						        				AS CD_USU
				   ,GETDATE()												AS DT_DOCUMENTO
				   ,'TRG_EST_PROD_INTEGRA_BENNER_EVENTOS - CARGA GERAL - FILIAL = '+ CAST(@CD_FILIAL AS VARCHAR(5))	AS [APP_NAME]
				   ,'Carga_filial-'+CAST(@CD_FILIAL AS VARCHAR(5))			AS HOST_NAME
				   ,2														AS TOPICO
			FROM 
				EST_PROD A
			WHERE
				A.STS_PROD = 0
			GROUP BY
				A.CD_PROD 
				,A.DT_ULT_ATU 			   
				,A.CD_USU 	
	END

	IF @CD_PROD > 0
	BEGIN
			INSERT INTO INTEGRA_BENNER_LOG_REPROCESSAMENTO(CD_FILIAL, TOTAL_REGISTROS, TIPO_REPROCESSAMENTO, DT_HR_ENVIO, APLICATIVO, HOST)
			SELECT
				   @CD_FILIAL	AS CD_FILIAL,
				   SUM(1)	AS TOTAL_REGISTROS,
				   'REPROCESSAMENTO GERAL DE TODOS OS REGISTROS ATIVOS' AS TIPO_REPROCESSAMENTO,
				   CURRENT_TIMESTAMP	AS  DT_HR_ENVIO,
				   APP_NAME()			AS APLICATIVO,
				   HOST_NAME()			AS HOST
			FROM 
				EST_PROD A
			WHERE
				A.STS_PROD = 0
				AND A.CD_PROD = @CD_PROD
		

	--DECLARE @CD_FILIAL INT = 569;
	--DECLARE @CD_PROD INT = 1;

		INSERT INTO INTEGRA_BENNER_EVENTOS (TABELA, CD_EMP , CD_FILIAL, CD_REGISTRO, TP_EVENTO, HR_EVENTO, ST_EVENTO , DT_ULT_ALT, CD_USU, DT_DOCUMENTO, APP_NAME, HOST_NAME, TOPICO )
			SELECT
				   'EST_PROD'												AS TABELA
				   ,1														AS CD_EMP
				   ,@CD_FILIAL						      					AS CD_FILIAL
				   ,A.CD_PROD 						        				AS CD_REGISTRO
				   ,1														AS TP_EVENTO
				   ,GETDATE()												AS HR_EVENTO
				   ,0														AS ST_EVENTO
				   ,A.DT_ULT_ATU 			    	        				AS DT_ULT_ALT
				   ,A.CD_USU 						        				AS CD_USU
				   ,GETDATE()												AS DT_DOCUMENTO
				   ,'INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO - ITEM - PRODUTO = '+ CAST(@CD_PROD AS VARCHAR(5)) + ' FILIAL = '+CAST(@CD_FILIAL AS VARCHAR(5))		AS [APP_NAME]
				   ,'Carga_filial-'+CAST(@CD_FILIAL AS VARCHAR(5))			AS HOST_NAME
				   ,2														AS TOPICO
			FROM 
				EST_PROD A
			WHERE
				A.STS_PROD = 0
				AND A.CD_PROD = @CD_PROD
			GROUP BY
				 A.CD_PROD 
				,A.DT_ULT_ATU 			   
				,A.CD_USU 
	END
		 PRINT 'Fim rotina P_INTEGRA_BENNER_EVENTOS_REPROCESSAMENTO '
		 SELECT TOP 1 @CD_FILIAL, TOTAL_REGISTROS, TIPO_REPROCESSAMENTO, DT_HR_ENVIO, APLICATIVO, HOST FROM INTEGRA_BENNER_LOG_REPROCESSAMENTO GROUP BY CD_FILIAL, TOTAL_REGISTROS, TIPO_REPROCESSAMENTO, DT_HR_ENVIO, APLICATIVO, HOST ORDER BY MAX(DT_HR_ENVIO);
END

ELSE 
	BEGIN
		PRINT 'FILIAL NO EXISTENTE OU ESTA INATIVA'
	END
END;